<?php
/*
Plugin Name: Alces WooCommerce Integration
Plugin URI: https://alcessoftware.com
Description: Integrate WooCommerce with Alces AI digital receipt system
Version: 1.0
Author: Alces Team
*/

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
if (!session_id()) {
    session_start();
}



// Add menu to WordPress admin
add_action('admin_menu', 'alces_admin_menu');
function alces_admin_menu() {
    add_menu_page(
        'Alces',
        'Alces',
        'manage_options',
        'alces-setup',
        'alces_setup_page',
        'dashicons-media-text'
    );
}

// Register settings
add_action('admin_init', 'alces_register_settings');
function alces_register_settings() {
    register_setting('alces_settings', 'alces_phone');
    register_setting('alces_settings', 'alces_token');
    register_setting('alces_settings', 'alces_active');
    register_setting('alces_settings', 'alces_setup_complete');
}




//ajax
add_action('wp_footer', 'alces_inline_script');
add_action('wp_footer', 'add_lottie_script');
function add_lottie_script() {
    ?>
 <script src="https://unpkg.com/@dotlottie/player-component@2.7.12/dist/dotlottie-player.mjs" type="module"></script>
    <?php
}
function alces_inline_script() {
    ?>
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function () {
            document.getElementById("send_receipt_button")?.addEventListener("click", function () {
                var orderId = this.getAttribute("data-order-id");

                var xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo admin_url('admin-ajax.php'); ?>", true);
                xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        console.log("Success:", xhr.responseText);
                    }
                };

                xhr.send("action=send_to_alces&order_id=" + orderId + "&send_type=receipt");
            });
        });
    </script>
    <?php
}



// API Helper function
function alces_api_request($endpoint, $method = 'GET', $body = null) {
    $api_url = 'http://my.alcessoftware.com/api/';
    $headers = array(
        'Content-Type' => 'application/json'
    );

    if(get_option('alces_token')) {
        $headers['Authorization'] = 'Bearer ' .get_option('alces_token');
    }


    $args = array(
        'headers' => $headers,
        'method' => $method
    );

    if($body) {
        $args['body'] = json_encode($body);
    }

    $response = wp_remote_request($api_url .$endpoint, $args);
  

 
    if(is_wp_error($response)) {
        return false;
    }

    return json_decode(wp_remote_retrieve_body($response), true);
}

function alces_get_countries() {
    $response = alces_api_request('config/countries');
    return $response && isset($response['result']) ? $response['result'] : array();
}

//check device
add_action('wp_dashboard_setup', 'alces_check_device');
function alces_check_device() {
    if (!is_user_logged_in() || !is_admin()) {
        return;
    }


    $token = get_option('alces_token');
    if (!$token) {
   return;
    }else{
        $response = alces_api_request('merchant/device/my-devices');
    

       if (!$response || !isset($response['status']) || $response['status'] !== true || !isset($response['result']) || !is_array($response['result'])) {
            setcookie('alces_redirected', 'step1', time() + 36, '/');
            wp_redirect(admin_url('admin.php?page=alces-setup&step=1'));
            exit;
        }

        $current_mac_address = $_SERVER['SERVER_NAME']; 
        $current_serial = $_SERVER['SERVER_ADDR']; 

        $device_found = false;
        foreach ($response['result'] as $device) {
            if ($device['mac_address'] === $current_mac_address && $device['serial'] === $current_serial) {
                $device_found = true;
                break;
            }
        }
        if (!$device_found) {
            setcookie('alces_error', 'step1', time() + 36, '/');
           delete_option('alces_token');
           
            wp_redirect(admin_url());
            update_option('alces_active',0);
            exit;
        }
    }
}
add_action('admin_notices', 'alces_device_not_found_notice');

function alces_device_not_found_notice() {
    if (isset($_COOKIE['alces_error'])) {
        echo '<div class="notice notice-error is-dismissible"><p>It seems your website has been removed from your devices list. in case you still want to use Alces integration in your website please setup again from "Alces" in menu.</p></div>';
        unset($_COOKIE['alces_error']);
        
    }
}



// Admin setup page
function alces_setup_page() {
    wp_enqueue_style('select2', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
    wp_enqueue_script('select2', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', array('jquery'));


    // Check for access token at the beginning
    $access_token = get_option('alces_token');
 

    // Set current step based on token existence
    $current_step = $access_token ? 3 : 1;

    // Override step if explicitly set in URL
    if (isset($_GET['step'])) {
        $current_step = $_GET['step'];
    }

    // Handle form submissions
    if(isset($_POST['action'])) {
        switch($_POST['action']) {
            case 'send_otp':
                // Send OTP request
                $response = alces_api_request('auth/send-otp', 'POST', array(
                    'mobile' => $_POST['mobile'],
                    'country_code' => $_POST['country']
                ));

                // Store values for verify step
                update_option('alces_temp_mobile', $_POST['mobile']);
                update_option('alces_temp_country_code', $_POST['country']);

                // Go to step 2
                wp_redirect(admin_url('admin.php?page=alces-setup&step=2'));
                exit;
                break;

            case 'verify_otp':
                // Send verify OTP request
                $response = alces_api_request('auth/verify-otp', 'POST', array(
                    'mobile' => get_option('alces_temp_mobile'),
                    'country_code' => get_option('alces_temp_country_code'),
                    'code' => $_POST['otp_code']
                ));

                if ($response && isset($response['status']) && $response['status'] === true) {
             
                        if (isset($response['result']['access_token'])) {
                                  // print_r($response['result']['access_token']);
                            update_option('alces_token', $response['result']['access_token']);
                            update_option('alces_active',1);
                            $response2 = alces_api_request('merchant/device/create', 'POST', array(
                                'mac_address' => $_SERVER['SERVER_NAME'],
                                'serial' => $_SERVER['SERVER_ADDR']
                            ));
                         
                            
                            if($response2["status"]==true){
                                update_option('alces_setup_complete', true);
                            }
                        }
                    

               
                    delete_option('alces_temp_mobile');
                    delete_option('alces_temp_country_code');

                  
                    wp_redirect(admin_url('admin.php?page=alces-setup&step=3'));
                    exit;
                }
                break;

            case 'logout':
            
                delete_option('alces_token');
                wp_redirect(admin_url('admin.php?page=alces-setup&step=1'));
                exit;
                break;
        }
    }

    /*if (isset($_POST['action']) && $_POST['action'] === 'verify_otp') {
        $otp_code = sanitize_text_field($_POST['otp_code']);
        $mobile = $_SESSION['alces_mobile'];
        $country_code = $_SESSION['alces_country_code'];

        $response = alces_api_request('auth/verify-otp', 'POST', array(
            'mobile' => $mobile,
            'country_code' => $country_code,
            'code' => $otp_code
        ));

        if ($response && isset($response['result']['access_token'])) {
            update_option('alces_token', $response['result']['access_token']);
            update_option('alces_setup_complete', true);
            unset($_SESSION['alces_mobile'], $_SESSION['alces_country_code']);
            wp_redirect(admin_url('admin.php?page=alces-setup'));
            exit;
        }
    }*/

    // Get countries for step 1
    
    $countries = ($current_step == 1) ? alces_get_countries() : array();
    
    ?>
    <div >
        <div class="wrap">
        <h2>Alces Setup</h2>

        <?php if($current_step == 1): ?>
            <form method="post">
                <input type="hidden" name="action" value="send_otp">
                <table class="form-table">
                    <tr>
                      
                        <td>
                            <select name="country" id="country-select"   required>
                                <option value="">Select Country</option>
                                <?php foreach($countries as $country): ?>
                                    <option value='<?php echo $country['phonecode'] ?>'>
                                        <?php echo esc_html($country['name'] . ' (+' . $country['phonecode'] . ')'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <input type="text"
                                   name="mobile"
                                   placeholder="Mobile Number"
                                   required>
                        </td>
                    </tr>
                </table>
                <?php submit_button('Send OTP'); ?>
            </form>

        <?php elseif($current_step == 2): ?>
            <form method="post">
                <input type="hidden" name="action" value="verify_otp">
                <table class="form-table">
                    <tr>
                    
                        <td>
                            <input type="text"
                                   name="otp_code"
                                   placeholder="Enter OTP Code"
                                   required>
                        </td>
                    </tr>
                </table>
                <?php submit_button('Verify OTP'); ?>
            </form>

        <?php elseif($current_step == 3): ?>
<?php
$checktoken = get_option('alces_token');
if(!$checktoken){
    wp_redirect(admin_url('admin.php?page=alces-setup&step=1')); 
} 
?> 
            <form method="post" action="options.php">
                <?php settings_fields('alces_settings'); ?>
                <table class="form-table form-table-step3">
                    <tr>
                    <div class="center-alces">
                       
                        <td>
                            <span>Active Alces In Your Site?</span>
                            <label>
                                <input type="checkbox" name="alces_active" value="1" <?php checked(get_option('alces_active'), 1); ?> />
                                Active
                            </label>
                        </td>
                        </div>
                    </tr>
                </table>
                <?php submit_button('Save Settings'); ?>
            </form>
</div>
            <form method="post">
                <input type="hidden" name="action" value="logout" class="logout-btn" />
                <?php submit_button('Logout', 'delete'); ?>
            </form>
        <?php endif; ?>
    </div>
<style>
.form-table-step3 td{
 justify-content: center;
    display: flex !important;
  

}
.form-table-step3 td span{
margin-right:20px;
  

}

.wp-core-ui .button.delete{
   background: #d9534f !important;
    box-shadow: 0 5px 10px rgba(217, 83, 79, 0.3) !important;
    width: 20% !important;
    margin-left: 25px;
}
            .select2-container--default .select2-selection--single {
    background-color: #f9f9f9;
    border: 1px solid #aaa;
    border-radius: 16px !important;
    box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3) !important;
}
.select2-dropdown--below{
    border-radius: 16 px !important;
    margin-top: 5px !important;
}
     .wrap {
            background: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: 30px auto;
            text-align: left;
        }
        
        .wrap h2 {
            font-size: 1.8em;
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }
        
        .form-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .form-table th {
            text-align: left;
            padding: 10px;
            font-size: 1em;
            color: #555;
            width: 30%;
        }
        
        .form-table td {
            padding: 10px;
        }
        
        #country-select,
        input[type="text"] {
            width: 100%;
            padding: 12px;
            border-radius: 16px;
            border: 1px solid #ddd;
            background: #f9f9f9;
            font-size: 1em;
            transition: all 0.3s ease-in-out;
                     align-content: center !important;
              text-align-last: center !important;
        }
        
        #country-select:focus,
        input[type="text"]:focus {
            border-color: #0073aa;
            box-shadow: 0 0 8px rgba(0, 115, 170, 0.3);
            outline: none;
        }
        
     .wp-core-ui .button {
            background: linear-gradient(135deg, #0073aa, #005177) ;
            color: white !important;
            font-size: 1em !important;
            font-weight: bold !important;
            padding: 12px 24px !important;
            border: none !important;
            border-radius: 8px !important;
            cursor: pointer !important;
            transition: all 0.3s ease-in-out !important;
            box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3) !important;
            text-transform: uppercase !important;
            width: 100% ;
            margin-top: 10px !important;
        }
        
        .wp-core-ui .button:hover {
            background: linear-gradient(135deg, #005177, #003955);
            transform: translateY(-2px);
            box-shadow: 0 8px 16px rgba(0, 115, 170, 0.4);
        }
        
       .wp-core-ui .button.delete {
            background: #d9534f;
            box-shadow: 0 5px 10px rgba(217, 83, 79, 0.3);
        }
        
        .wp-core-ui .button.delete:hover {
            background: #c9302c;
            box-shadow: 0 8px 16px rgba(217, 83, 79, 0.4);
        }
        
        label {
            font-size: 1em;
            color: #555;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        input[type="checkbox"] {
            width: 18px;
            height: 18px;
            accent-color: #0073aa;
        }
        .select2-container {
            width:100% !important;
            margin-bottom:20px !important;
           
        }
   .select2-selection--single {
          height: 50px !important;
              align-content: center !important;
              text-align-last: center !important;
        }
        .select2-selection__arrow {
        
            top: 14px !important;
          
        }

    
    
</style>
    <script>
        jQuery(document).ready(function($) {
            $('#country-select').select2();
        });
    </script>
    <?php
}



// Add "Send to Alces" button with modal
add_action('woocommerce_order_details_after_order_table', 'add_alces_button');
function add_alces_button($order) {
    

    
    if(get_option('alces_active')) {
        
    $countries2= alces_get_countries();
        //print_r($countries2);
        ?>
        <!-- Modal HTML -->
        <div id="alces-modal" class="alces-modal" style="display: none;">
            <div class="alces-modal-content">
                <div class="alces-modal-header">
                    <h3>Send Receipt to Alces</h3>
                    <span class="alces-close">&times;</span>
                </div>
                <div class="alces-modal-body">
                    <p>Choose how you want to receive the receipt:</p>
                    <div class="alces-button-group">
                        <button type="button" class="button button-primary" id="alces-qrcode" data-type="qrcode">
                            <span class="dashicons dashicons-qr"></span>
                            QR Code
                        </button>
                        <button type="button" class="button button-primary" id="alces-phone" data-type="phone">
                            <span class="dashicons dashicons-phone"></span>
                            Phone Number
                        </button>
                    </div>
                    <div id="alces-response" class="alces-response" style="display: none;"></div>
                </div>
            </div>
        </div>
        

        <!-- Main Button -->
        <button type="button" class="button" id="alces-send-button">Send Receipt To Alces</button>

        <style>
       
       .alces-modal {
                display: none;
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.4);
                backdrop-filter: blur(5px);
            }
                     
           .alces-phone-form {
                display: flex;
                flex-direction: column;
                gap: 10px;
            }

      

            .alces-modal-content {
                 background-color: #ffffff;
                margin: 10% auto;
                padding: 0;
                width: 90%;
                max-width: 420px;
                border-radius: 12px;
                box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15);
                animation: fadeIn 0.3s ease-in-out;
                overflow: hidden;
            }
            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: translateY(-10px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
            .alces-modal-header {
                padding: 16px;
                background-color: #0073aa;
                color: white;
                font-size: 1.3em;
                font-weight: bold;
                text-align: center;
                border-top-left-radius: 12px;
                border-top-right-radius: 12px;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .alces-modal-header h3 {
                color:white;
                margin: 0;
                font-size: 1.2em;
                    padding-left: 75px;
            }

            .alces-close {
                 cursor: pointer;
                font-size: 1.8em;
                font-weight: bold;
                transition: 0.3s;
            }
            .alces-close:hover {
            color: #ff3b3b;
                   }
         .alces-modal-body {
                padding: 20px;
                text-align: center;
            }
            
            .alces-button-group {
                display: flex;
                gap: 12px;
                justify-content: center;
                margin-top: 20px;
            }

        .alces-button-group button {
                padding: 12px 20px;
                display: flex;
                align-items: center;
                gap: 8px;
                border-radius: 8px;
                font-size: 1em;
                border: none;
                cursor: pointer;
                transition: 0.3s ease-in-out;
                box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3);
            }
            
            .alces-button-group button:hover {
                transform: translateY(-2px);
                box-shadow: 0 8px 16px rgba(0, 115, 170, 0.4);
            }

            .dashicons {
                font-size: 20px;
                width: 20px;
                height: 20px;
            }
            
            #alces-qrcode {
                background-color: #0073aa;
                color: white;
            }
            
            #alces-phone {
                background-color: #28a745;
                color: white;
            }
            
            #alces-qrcode:hover {
                background-color: #005177;
            }
            
            #alces-phone:hover {
                background-color: #1d923a;
            }
            #alces-send-button {
                background: linear-gradient(135deg, #0073aa, #005177);
                color: white;
                font-size: 1em;
                font-weight: bold;
                padding: 12px 24px;
                border: none;
                border-radius: 8px;
                cursor: pointer;
                transition: all 0.3s ease-in-out;
                box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3);
                display: flex;
                align-items: center;
                gap: 10px;
                justify-content: center;
                text-transform: uppercase;
                margin:20px 5px 10px 5px;
                 
            }
            
            #alces-send-button:hover {
                background: linear-gradient(135deg, #005177, #003955);
                transform: translateY(-2px);
                box-shadow: 0 8px 16px rgba(0, 115, 170, 0.4);
            }
            
            #alces-send-button:active {
                transform: translateY(1px);
                box-shadow: 0 4px 8px rgba(0, 115, 170, 0.2);
            }
            
            #alces-send-button::before {
                content: "📤";
                font-size: 1.2em;
            }



        .alces-response {
                margin-top: 15px;
                padding: 15px;
                border-radius: 6px;
                font-weight: bold;
            }

            .alces-response.success {
                background-color: #dff0d8;
                border: 1px solid #d6e9c6;
                color: #3c763d;
            }

            .alces-response.error {
                background-color: #f2dede;
                border: 1px solid #ebccd1;
                color: #a94442;
            }

             .alces-loading {
                text-align: center;
                padding: 12px;
                font-weight: bold;
            }
           .alces-phone-form {
                padding: 20px;
                display: flex;
                flex-direction: column;
                gap: 15px;
                align-items: center;
                text-align: center;
                max-width: 400px;
                margin: auto;
            }
            
            .alces-phone-form p {
                font-size: 1.1em;
                font-weight: bold;
                color: #333;
            }
            
            #alces-country-code {
                width: 100%;
                padding: 10px;
                border-radius: 8px; 
                border: 1px solid #ddd;
                background: #f9f9f9;
                font-size: 1em;
                transition: all 0.3s ease-in-out;
            }
            
            #alces-country-code:focus {
                border-color: #0073aa;
                box-shadow: 0 0 8px rgba(0, 115, 170, 0.3);
                outline: none;
            }
            .select2-container--default .select2-selection--single {
    background-color: #f9f9f9;
    border: 1px solid #aaa;
    border-radius: 16px !important;
    box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3) !important;
}
.select2-dropdown--below{
    border-radius: 16px !important;
    margin-top: 5px !important;
}
            #alces-mobile {
                width: 322px;
                height: 35px;
                box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3) !important;
                padding: 10px;
                border-radius: 16px;
                border: 1px solid #ddd;
                background: #f9f9f9;
                font-size: 1em;
                transition: all 0.3s ease-in-out;
                    text-align-last: center;
            }
            
            #alces-mobile:focus {
                border-color: #0073aa;
                box-shadow: 0 0 8px rgba(0, 115, 170, 0.3);
                outline: none;
            }
            
            #alces-receive-button {
                background: linear-gradient(135deg, #0073aa, #005177);
                color: white;
                font-size: 1em;
                font-weight: bold;
                padding: 12px 24px;
                border: none;
                border-radius: 16px;
                cursor: pointer;
                transition: all 0.3s ease-in-out;
                box-shadow: 0 5px 10px rgba(0, 115, 170, 0.3);
                text-transform: uppercase;
                width: 100%;
            }
            
            #alces-receive-button:hover {
                background: linear-gradient(135deg, #005177, #003955);
                transform: translateY(-2px);
                box-shadow: 0 8px 16px rgba(0, 115, 170, 0.4);
            }
            
            #alces-receive-button:active {
                transform: translateY(1px);
                box-shadow: 0 4px 8px rgba(0, 115, 170, 0.2);
            }

               #qrcode-result {
                text-align: center;
                margin-top: 15px;
            }
            
            #qrcode-result img {
                width: 60%;
                height: auto;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            }
            .lottie-result{
                text-align: -webkit-center !important;
            
            }
        </style>

 <script>
 
jQuery(document).ready(function($) {
    const modal = $('#alces-modal');
    const responseDiv = $('#alces-response');
    const modalBody = $('.alces-modal-body');

    $('#alces-send-button').click(function() {
        modal.show();
    });

    $('.alces-close, .alces-modal').click(function(e) {
        if (e.target === this) {
            modal.hide();
        }
    });
$('#alces-qrcode').click(function() {
    const orderId = '<?php echo $order->get_id(); ?>';

    modalBody.html('<div class="alces-loading">Generating QR Code...</div>');

    $.ajax({
        url: '<?php echo admin_url('admin-ajax.php'); ?>',
        type: 'POST',
        data: {
            action: 'send_qrcode_to_alces',
            order_id: orderId,
            nonce: '<?php echo wp_create_nonce("send_to_alces"); ?>'
        },
        success: function(response) {
            if (response.success) {
                const qrUrl = response.data.qr_url;
                const qrCodeImageUrl = response.data.qr_code_image_url;

              
                modalBody.html(`
                    <div id="qrcode-result" class="alces-success">
                        <p>Scan the QR code below:</p>
                        <img src="${qrCodeImageUrl}" alt="QR Code">
                        <br>
                     
                    </div>
                `);
            } else {
                modalBody.html('<p class="alces-error">Error: ' + (response.data || 'Failed to generate QR code') + '</p>');
            }
        },
        error: function(xhr, status, error) {
            modalBody.html('<p class="alces-error">Error: ' + error + '</p>');
        }
    });
});


    $('#alces-phone').click(function() {
        const orderId = '<?php echo $order->get_id(); ?>';
        modalBody.html(`
            <div class="alces-phone-form">
                <p>Your Alces Phone Number:</p>
        
                                            
                    <select name="country2" id="alces-country-code"  required>
                        <option value="">Select Country</option>
                        
                            <?php foreach ($countries2 as $c): ?>
                                <option value="<?php echo $c['phonecode']; ?>">
                                    <?php echo esc_html($c['name'] . ' (+' . $c['phonecode'] . ')'); ?>
                                </option>
                            <?php endforeach; ?>

                    </select>
                <input type="text" id="alces-mobile" placeholder="Mobile Number" required>
                <button type="button" class="button button-primary" id="alces-receive-button">Receive</button>
                <div id="alces-response" class="alces-response" style="display: none;"></div>
            </div>
        `);

        // Initialize Select2
        $('#alces-country-code').select2({
            placeholder: "Select Country",
            allowClear: true
        });

        // Fetch countries from API
        // $.ajax({
        //     url: '<?php echo admin_url('admin-ajax.php'); ?>',
        //     type: 'POST',
        //     data: {
        //         action: 'get_countries'
        //     },
        //     success: function(response) {
        //         if (response.success) {
        //             const countries = response.data;
        //             countries.forEach(country => {
        //                 $('#alces-country-code').append(new Option(country.name + ' (+' + country.phonecode + ')', country.phonecode));
        //             });
        //         } else {
        //             console.error('Failed to fetch countries');
        //         }
        //     },
        //     error: function(xhr, status, error) {
        //         console.error('Error fetching countries:', error);
        //     }
        // });

        $('#alces-receive-button').click(function() {
            const countryCode = $('#alces-country-code').val();
            const mobile = $('#alces-mobile').val();

            if (!countryCode || !mobile) {
                alert('Please fill in all fields');
                return;
            }

            responseDiv.html('<div class="alces-loading">Sending receipt...</div>').show();

            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'send_to_alces',
                    order_id: orderId,
                    send_type: 'phone',
                    country_code: countryCode,
                    mobile: mobile,
                    nonce: '<?php echo wp_create_nonce("send_to_alces"); ?>'
                },
                success: function(response) {
    if (response.success) {
        modalBody.html(`
            <div class="lottie-result" class="alces-success">
<dotlottie-player src="https://lottie.host/6cab9b1c-fa49-4b6d-af90-0ca73093348b/x8dl1m0wfA.lottie" background="transparent" speed="1" style="width: 300px; height: 300px" loop autoplay></dotlottie-player>
               
            </div>
        `);
    } else {
        modalBody.html(`
           <div class="lottie-result" class="alces-success">
<dotlottie-player src="https://lottie.host/edf86395-958d-4b94-9305-37d331dd00db/6JUhr8pgc2.lottie" background="transparent" speed="1" style="width: 300px; height: 300px" loop autoplay></dotlottie-player>
  </div>
`);
    }
},
                error: function(xhr, status, error) {
                    responseDiv
                        .html('Error: ' + error)
                        .removeClass('success')
                        .addClass('error')
                        .show();
                }
            });
        });
    });
});
</script>

        <?php
    }
}

// Add AJAX handler

function handle_send_to_alces_ajax() {
    // check_ajax_referer('send_to_alces', 'nonce');

    $order_id = $_POST['order_id'];
    
    $order = wc_get_order($order_id);

    if (!$order) {
        wp_send_json_error('Invalid order ID');
        return;
    }

    // Prepare receipt data
    $data = array(
        'companyDetails' => array(
            'name' => get_bloginfo('name'),
            'address' => get_option('woocommerce_store_address'),
            'email' => get_bloginfo('admin_email'),
            'website' => get_bloginfo('url'),
            'EIN' => null
        ),
        'receiptDetails' => array(
            'receiptType' => 'Receipt',
            'receiptNumber' => $order->get_order_number(),
            'date' => $order->get_date_created()->format('Y-m-d\TH:i:s\Z'),
            'due_date' => $order->get_date_created()->format('Y-m-d\TH:i:s\Z'),
            'customer' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
            'customerAddress' => implode(', ', array_filter([
                $order->get_billing_address_1(),
                $order->get_billing_address_2(),
                $order->get_billing_city(),
                $order->get_billing_state(),
                $order->get_billing_postcode(),
                $order->get_billing_country()
            ])),
            'paymentMethod' => $order->get_payment_method_title(),
            'cardNumber' => null,
            'currency' => $order->get_currency(),
            'processedBy' => null,
            'license' => null,
            'terminal' => null,
            'printTime' => $order->get_date_created()->format('Y-m-d H:i:s'),
            'softwareVersion' => null,
            'type_request' => "payment",
            'storage' => array()
        ),
        'items' => array(),
        'total' => array(
            'net' => $order->get_subtotal(),
            'tax' => $order->get_total_tax(),
            'final' => $order->get_total()
        ),
        'taxDetails' => array(
            'designation' => null,
            'taxPercentage' => 0,
            'taxBase' => $order->get_subtotal(),
            'totalTax' => $order->get_total_tax()
        )
    );


    // Add order items
    foreach($order->get_items() as $item) {
        $data['items'][] = array(
            'name' => $item->get_name(),
            'taxPercentage' => null,
            'quantity' => $item->get_quantity(),
            'unit' => 'un',
            'price' => $item->get_subtotal() / $item->get_quantity(),
            'discount' => $item->get_subtotal() - $item->get_total(),
            'total' => $item->get_total()
        );
    }




    // Send to Alces API
    

        $send_type = $_POST['send_type'];
        $mobile = $_POST['mobile'];
        $country_code = $_POST['country_code'];
  
    
    $response = alces_api_request('merchant/receipt/save', 'POST',$data);
 

  
   /*if (is_wp_error($response)) {
        wp_send_json_error($response->get_error_message());
        return;
    }*/

    /*if (!$response || !isset($response['status']) || $response['status'] !== true) {
        $error_message = isset($response['message']) ? $response['message'] : 'Unknown error';
        wp_send_json_error($error_message);
        return;
    }*/


    
     
    $response2 = alces_api_request('merchant/receipt/assign-receipt-device/'.$response['receipt']['id'], 'POST',array(
                        'mac_address' => $_SERVER['SERVER_NAME'],
                        'serial' => $_SERVER['SERVER_ADDR']
                    ));
                     
 //print_r($response2);
  //die();
                    
    if (is_wp_error($response2)) {
        wp_send_json_error($response2->get_error_message());
        return;
    }

    if (!$response2 || !isset($response2['status']) || $response2['status'] !== true) {
        $error_message = isset($response2['message']) ? $response2['message'] : 'Unknown error';
        wp_send_json_error($error_message);
        return;
    }
               
               

                
             return array('status' => true, 'response' => $response);   
               

    if ($response && isset($response['status']) && $response['status'] === true) {
        wp_send_json_success($response);
    } else {
        $error_message = isset($response['message']) ? $response['message'] : 'Unknown error';
        wp_send_json_error($error_message);
    }
    
}
add_action('wp_ajax_send_to_alces', 'phone_number_send_receipt');
function phone_number_send_receipt(){
    check_ajax_referer('send_to_alces', 'nonce');
    
        $send_type = $_POST['send_type'];
        $mobile = $_POST['mobile'];
        $country_code = $_POST['country_code'];
        
         $data_and_assign = handle_send_to_alces_ajax() ;
        

       if (!$data_and_assign['status']) {
        wp_send_json_error($data_and_assign['message']);
        return;
    }
       
        $response3 = alces_api_request('merchant/receipt/assign-user/by-mobile/'.$data_and_assign['response']['receipt']['id'], 'POST',array(
                    'mobile' => $mobile,
                    'country_code' => $country_code
                ));
                //  print_r($data_and_assign);
                
                   if (is_wp_error($response3)) {
        wp_send_json_error($response3->get_error_message());
        return;
    }
                  
                 if ($response3 && isset($response3['status']) && $response3['status'] === true) {
        wp_send_json_success($response3);
    } else {
        $error_message = isset($response3['message']) ? $response3['message'] : 'Unknown error';
        wp_send_json_error($error_message);
    }
    
}
add_action('wp_ajax_send_qrcode_to_alces', 'qrcode_send_receipt');
function qrcode_send_receipt() {
    check_ajax_referer('send_to_alces', 'nonce');

    $data_and_assign = handle_send_to_alces_ajax();
   

    if (!$data_and_assign['status']) {
        wp_send_json_error($data_and_assign['message']);
        
        return;
    }

  
    $qr_code_hashed = $data_and_assign['response']['receipt']['qr_code_hashed'];
   

    if (!$qr_code_hashed) {
        wp_send_json_error('QR Code not found in receipt response');
        return;
    }

   
    $qr_url = "http://my.alcessoftware.com/web-client/scan-receipt/{$qr_code_hashed}/personal";

   
    $qr_code_image_url = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($qr_url);

 
    wp_send_json_success([
        'qr_code_hashed' => $qr_code_hashed,
        'qr_code_image_url' => $qr_code_image_url,
        'qr_url' => $qr_url
    ]);
}